unit Service03;

//             
//           IMAGE
//         24.04.2017

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs;

// =========================================================================
// -------------------------------------------------------------------------
//   
type TVector2D = record
  X : extended;
  Y : extended;
end;
// -------------------------------------------------------------------------
//   
type TVector3D = record
  X : extended;
  Y : extended;
  Z : extended;
end;
// -------------------------------------------------------------------------
//        
type TVector2DP = record
  X : extended;
  Y : extended;
  Len : extended;
  Ang : extended;
end;
// -------------------------------------------------------------------------
// -------------------------------------------------------------------------
//      TVector2D
function SumVector2D(const V1, V2 : TVector2D): TVector2D;

//  (V1 - V2)   TVector2D
function SubVector2D(const V1, V2 : TVector2D): TVector2D;

// -------------------------------------------------------------------------
//      TVector3D
function SumVector3D(const V1, V2 : TVector3D): TVector3D;

//  (V1 - V2)   TVector3D
function SubVector3D(const V1, V2 : TVector3D): TVector3D;

// -------------------------------------------------------------------------
//      
procedure DecartToPolar (var V : TVector2DP);  register;

// -------------------------------------------------------------------------
//      
procedure PolarToDecart(var V : TVector2DP); register;

// =========================================================================
// -------------------------------------------------------------------------
//    RqX,RqY  RqRect
function IsXYInRect(const RqRect : TRect; RqX, RqY : integer): boolean;

//    RqPoint  RqRect
// . PtInRect
function IsPointInRect(const RqRect : TRect; RqPoint : TPoint): boolean;

//   RqRect  RqMainRect
function IsRectInMainRect(const RqMainRect, RqRect : TRect): boolean;

//   RqRect (    Rect)
// . IsRectEmpty
function IsEmptyRect(const RqRect : TRect): boolean;

//    RqRect (     Rect)
// . IntersectRect
function IsCrossRect(const RqRect1, RqRect2 : TRect): boolean;

//    TBmp  RqRect
function  IsBmpEqualRect(RqBmp : TBitMap; RqRect : TRect) : boolean;

//  RqRect    RqX, RqY
function MoveRectangle (RqRect : TRect; RqX, RqY : integer) : TRect;

//   Bitmap   FromBitMap  FomRect
function SaveBitMap(FromBitMap, Bitmap : TBitmap;
                    FomRect : TRect) : boolean;

//   Bitmap   ToBitMap   
function RestoreBitMap(BitMap   : TBitmap;  // BitMap 
                       ToBitMap : TBitmap;  // BitMap 
                       Xb, Yb   : integer)  //    
                       : boolean; overload;

//   Bitmap   ToBitMap   
//      TrColor
// 29.01.2017
function RestoreBitMap(BitMap   : TBitmap;  // BitMap 
                       ToBitMap : TBitmap;  // BitMap 
                       Xb, Yb   : integer;  //    
                       TrColor  : TColor)   //  
                       : boolean;  overload;

// =========================================================================
// =========================================================================

implementation

// =========================================================================
// =========================================================================
//       
// =========================================================================
// -------------------------------------------------------------------------
//      TVector2D
// 06.02.2017
function SumVector2D(const V1, V2 : TVector2D): TVector2D;
begin
    Result.X := V1.X + V2.X;
    Result.Y := V1.Y + V2.Y;
end;
// -------------------------------------------------------------------------
//  (V1 - V2)   TVector2D
// 06.02.2017
function SubVector2D(const V1, V2 : TVector2D): TVector2D;
begin
    Result.X := V1.X - V2.X;
    Result.Y := V1.Y - V2.Y;
end;
// -------------------------------------------------------------------------
//      TVector3D
// 06.02.2017
function SumVector3D(const V1, V2 : TVector3D): TVector3D;
begin
    Result.X := V1.X + V2.X;
    Result.Y := V1.Y + V2.Y;
    Result.Y := V1.Z + V2.Z;
end;
// -------------------------------------------------------------------------
//  (V1 - V2)   TVector3D
// 06.02.2017
function SubVector3D(const V1, V2 : TVector3D): TVector3D;
begin
    Result.X := V1.X - V2.X;
    Result.Y := V1.Y - V2.Y;
    Result.Y := V1.Z - V2.Z;
end;
// -------------------------------------------------------------------------
// 12.02.2017
//      
procedure DecartToPolar (var V : TVector2DP);  register;
asm
  FINIT                       //      (FPU)
                              //   FPU   
  FLD   TVector2DP.Y [EAX]    // (V.Y);
  FLD   TVector2DP.X [EAX]    // (V.X); (V.Y);
  //    
  FLD   ST(1)                 // (V.Y); (V.X); (V.Y)
  FLD   ST(1)                 // (V.X); (V.Y); (V.X); (V.Y);
  FPATAN                      // ArcTan((V.X); (V.Y)); (V.X); (V.Y);
  FSTP  TVector2DP.Ang [EAX]  // (V.X); (V.Y)
  //  
  FLD  ST(0)                  // (V.X); (V.X); (V.Y);
  FMUL                        // (V.X * V.X); (V.Y);
  FXCH ST(1)                  // (V.Y); (V.X * V.X);
  FLD  ST(0)                  // (V.Y); (V.Y); (V.X * V.X)
  FMUL                        // (V.Y * V.Y); (V.X * V.X);
  FADD                        // ((V.Y * V.Y) + (V.X * V.X));
  FSQRT                       //  sqrt((V.Y * V.Y) + (V.X * V.X));
  FSTP TVector2DP.Len [EAX]   // [empty]
  FWAIT
end;
// -------------------------------------------------------------------------
// 12.02.2017
//      
procedure PolarToDecart(var V : TVector2DP); register;
asm
  FINIT                         //      (FPU)
                                //   FPU   
  FLD   TVector2DP.Len [EAX]    // (V.Len)
  FLD   TVector2DP.Ang [EAX]    // (V.Len)
  FSINCOS                       // (cos(V.Ang)); (sin(V.Ang)); (V.Len)
  FMUL  ST, ST(2)               // (V.Len * cos(V.Ang)); (sin(V.Ang)); (V.Len)
  FSTP  TVector2DP.X [EAX]      // (sin(V.Ang)); (V.Len)
  FMUL                          // (V2P.Len * sin(V2P.Ang))
  FSTP  TVector2DP.Y [EAX]      // [empty]
  FWAIT
end;




// =========================================================================
//         IMAGE
// =========================================================================
// -------------------------------------------------------------------------
// 29.01.2017
//    RqX,RqY  RqRect
function IsXYInRect(const RqRect : TRect; RqX, RqY : integer): boolean;
begin
  Result := (RqX >= RqRect.Left) and (RqX <= RqRect.Right) and
            (RqY >= RqRect.Top)  and (RqY <= RqRect.Bottom);
end;

// -------------------------------------------------------------------------
//    RqPoint  RqRect
// . PtInRect
// 29.01.2017
function IsPointInRect(const RqRect : TRect; RqPoint : TPoint): boolean;
begin
  Result := (RqPoint.X >= RqRect.Left)  and
            (RqPoint.X <= RqRect.Right) and
            (RqPoint.Y >= RqRect.Top)   and
            (RqPoint.Y <= RqRect.Bottom);
end;

// -------------------------------------------------------------------------
//   RqRect  RqMainRect
// 29.01.2017
function IsRectInMainRect(const RqMainRect, RqRect : TRect): boolean;
begin
  Result := IsXYInRect(RqMainRect, RqRect.Left,  RqRect.Top) and
            IsXYInRect(RqMainRect, RqRect.Right, RqRect.Bottom);
end;

// -------------------------------------------------------------------------
//   RqRect (    Rect)
// . IsRectEmpty
// 29.01.2017
function IsEmptyRect(const RqRect : TRect): boolean;
begin
  Result := IsRectEmpty(RqRect);
end;

// -------------------------------------------------------------------------
//    RqRect (     Rect)
// . IntersectRect
// 29.01.2017
function IsCrossRect(const RqRect1, RqRect2 : TRect): boolean;
begin
  Result :=  IsXYInRect(RqRect1, RqRect2.Left,  RqRect2.Top)    or
             IsXYInRect(RqRect1, RqRect2.Right, RqRect2.Bottom) or
             IsXYInRect(RqRect1, RqRect2.Right, RqRect2.Top)    or
             IsXYInRect(RqRect1, RqRect2.Left,  RqRect2.Bottom) or
             IsXYInRect(RqRect2, RqRect1.Left,  RqRect1.Top)    or
             IsXYInRect(RqRect2, RqRect1.Right, RqRect1.Bottom) or
             IsXYInRect(RqRect2, RqRect1.Right, RqRect1.Top)    or
             IsXYInRect(RqRect2, RqRect1.Left,  RqRect1.Bottom);
end;

// -------------------------------------------------------------------------
//    TBmp  RqRect
// 29.01.2017
function  IsBmpEqualRect(RqBmp : TBitMap; RqRect : TRect) : boolean;
begin
   Result := False;
   if Assigned(RqBmp)
   then begin
      if RqBmp.Height <> (RqRect.Bottom - RqRect.Top) + 1 then Exit;
      if RqBmp.Width  <> (RqRect.Right - RqRect.Left) + 1 then Exit;
      Result := True;
   end;
end;

// -------------------------------------------------------------------------
//  RqRect    RqX, RqY
// 29.01.2017
function MoveRectangle (RqRect : TRect; RqX, RqY : integer) : TRect;
begin
  Result := Rect(RqX, RqY,
                 RqX + (RqRect.Right  - RqRect.Left),
                 RqY + (RqRect.Bottom - RqRect.Top ));
end;

 // -------------------------------------------------------------------------
//   Bitmap   FromBitMap  FomRect
// 24.04.2017
function SaveBitMap(FromBitMap, Bitmap : TBitmap;
                    FomRect : TRect) : boolean;
//  ------------------------------------
//  SysUtils:
//  PByteArray = ^TByteArray;
//  TByteArray = array[0..32767] of Byte;
//  ------------------------------------
var
  RowBeg,  ColBeg : Integer;
  RowEnd,  ColEnd : Integer;
  PFrom,   PTo    : PByteArray;
  RowFrom, RowTo  : Integer;
  ColFrom, ColTo  : Integer;
begin
  Result := False;
  if not (FromBitMap.PixelFormat = pf24bit) then Exit;
  //    FomRec
  // 1) FomRect   FromBitMap
  if FomRect.Top  >= FromBitMap.Height then Exit;
  if FomRect.Left >= FromBitMap.Width  then Exit;
  // 2)   
  RowBeg := FomRect.Top;
  if RowBeg < 0 then RowBeg := 0;
  RowEnd := FomRect.Bottom;
  if RowEnd > FromBitMap.Height - 1 then RowEnd := FromBitMap.Height - 1;
  // 3)   
  ColBeg := FomRect.Left;
  if ColBeg < 0 then ColBeg := 0;
  ColEnd := FomRect.Right;
  if ColEnd > FromBitMap.Width - 1 then ColEnd := FromBitMap.Width;
  // 4)    FomRec
  if RowEnd < RowBeg  then Exit;
  if ColEnd < ColBeg  then Exit;
  //  
  try
     Bitmap.PixelFormat := pf24bit;
     Bitmap.Height := RowEnd - RowBeg + 1;
     Bitmap.Width  := ColEnd - ColBeg + 1;
     RowTo := 0;
     for RowFrom := RowBeg to RowEnd do
     begin
       //   BitMap     
       PFrom := FromBitMap.ScanLine[RowFrom];
       PTo   := Bitmap.ScanLine[RowTo];
       ColTo := 0;
       ColFrom := 3 * ColBeg;
       Move(PFrom^[ColFrom], PTo^[ColTo], 3 * (ColEnd - ColBeg + 1));
(*     // 24.04.2017
       //  .     pf24bit : B,G,R
       for ColFrom := ColBeg * 3 to ColEnd * 3
       do begin
          PTo^[ColTo] := PFrom^[ColFrom];
          Inc(ColTo);
       end;
*)
       Inc(RowTo);
     end;
     Result := True;
  except
     ShowMessage('   BitMap');
  end;
end; // of function

// -------------------------------------------------------------------------
//   Bitmap   ToBitMap   
// 24.04.2017
function RestoreBitMap(BitMap   : TBitmap;  // BitMap 
                       ToBitMap : TBitmap;  // BitMap 
                       Xb, Yb   : integer)  //    
                       : boolean;  overload;
var
  RowBeg,  ColBeg : Integer;
  RowEnd,  ColEnd : Integer;
  PFrom,   PTo    : PByteArray;
  RowFrom, RowTo  : Integer;
  ColFrom, ColTo  : Integer;
begin
  Result := False;
  if not (ToBitmap.PixelFormat = pf24bit) then Exit;
  //    FomRec
  // 1) Xb, Yb   ToBitMap
  if Yb >= ToBitmap.Height then Exit;
  if Xb >= ToBitmap.Width  then Exit;
  // 2)   
  RowBeg := Yb;
  if Yb < 0
  then begin
      RowBeg := 0;
      RowEnd := BitMap.Height - 1;
  end
  else RowEnd := Yb + BitMap.Height - 1;
  if RowEnd  > ToBitMap.Height - 1 then RowEnd := ToBitMap.Height - 1;
  // 3)   
  ColBeg := Xb;
  if Xb < 0
  then begin
     ColBeg := 0;
     ColEnd := BitMap.Width - 1;
  end
  else ColEnd := Xb + BitMap.Width - 1;
  if ColEnd  > ToBitMap.Width - 1 then ColEnd := ToBitMap.Width;
  // 4)    ToRec
  if RowEnd < RowBeg  then Exit;
  if ColEnd < ColBeg  then Exit;
  //  
  try
     RowFrom := 0;
     for RowTo := RowBeg to RowEnd do
     begin
       //    BitMap     
       PFrom := BitMap.ScanLine[RowFrom];
       PTo   := ToBitmap.ScanLine[RowTo];
       ColFrom := 0;
       ColTo := 3 * ColBeg;
       Move(PFrom^[ColFrom], PTo^[ColTo], 3 * (ColEnd - ColBeg + 1));
(*     // 24.04.2017
       //  .     pf24bit : B,G,R
       for ColTo := ColBeg * 3 to ColEnd * 3
       do begin
          PTo^[ColTo] := PFrom^[ColFrom];
          Inc(ColFrom);
       end;
*)
       Inc(RowFrom);
     end;
     Result := True;
  except
     ShowMessage('   BitMap');
  end;
end; // of function

// -------------------------------------------------------------------------
//   Bitmap   ToBitMap   
//      TrColor
// 29.01.2017
function RestoreBitMap(BitMap   : TBitmap;  // BitMap 
                       ToBitMap : TBitmap;  // BitMap 
                       Xb, Yb   : integer;  //    
                       TrColor  : TColor)   //  
                       : boolean;  overload;
// ------------------------------------
//    TColor
type TCL32 = packed record
    B : byte;
    G : byte;
    R : byte;
    S : byte;
end;
type TpCL32 = ^TCL32;
// ------------------------------------
//    PixelFormat = pf24bit
type TCL24 = packed record
    B : byte;
    G : byte;
    R : byte;
end;
type TpCL24 = ^TCL24;
// ------------------------------------
var
  pCL32           : TpCL32;
  TrCL24          : TCL24;
  RowBeg,  ColBeg : Integer;
  RowEnd,  ColEnd : Integer;
  PFrom,   PTo    : PByteArray;
  RowFrom, RowTo  : Integer;
  ColFrom, ColTo  : Integer;
  pCL24From       : TpCL24;
  pCL24To         : TpCL24;
begin
  Result := False;
  if not (ToBitmap.PixelFormat = pf24bit) then Exit;
  //    FomRec
  // 1) Xb, Yb   ToBitMap
  if Yb >= ToBitmap.Height then Exit;
  if Xb >= ToBitmap.Width  then Exit;
  // 2)   
  RowBeg := Yb;
  if Yb < 0
  then begin
      RowBeg := 0;
      RowEnd := BitMap.Height - 1;
  end
  else RowEnd := Yb + BitMap.Height - 1;
  if RowEnd  > ToBitMap.Height - 1 then RowEnd := ToBitMap.Height - 1;
  // 3)   
  ColBeg := Xb;
  if Xb < 0
  then begin
     ColBeg := 0;
     ColEnd := BitMap.Width - 1;
  end
  else ColEnd := Xb + BitMap.Width - 1;
  if ColEnd  > ToBitMap.Width - 1 then ColEnd := ToBitMap.Width;
  // 4)    ToRec
  if RowEnd < RowBeg  then Exit;
  if ColEnd < ColBeg  then Exit;
  //    
  pCL32 := Addr(TrColor);
  TrCL24.B := pCL32^.B;
  TrCL24.G := pCL32^.G;
  TrCL24.R := pCL32^.R;
  //  
  try
     RowFrom := 0;
     for RowTo := RowBeg to RowEnd do
     begin
       //    BitMap 
       //    
       PFrom := BitMap.ScanLine[RowFrom];
       PTo   := ToBitmap.ScanLine[RowTo];
       // ------------------------------
       ColFrom := 0;
       ColTo   := ColBeg * 3;
       while ColTo < ColEnd * 3
       do begin
          pCL24From := Addr(PFrom^[ColFrom]);
          pCL24To   := Addr(PTo^[ColTo]);
          //   
          if (TrCL24.B <> pCL24From^.B) or
             (TrCL24.G <> pCL24From^.G) or
             (TrCL24.R <> pCL24From^.R)
          then begin
             //  
             pCL24To^ := pCL24From^
          end;
          ColTo := ColTo + 3;
          ColFrom := ColFrom + 3;
       end;
       // ------------------------------
       //  
       Inc(RowFrom);
     end;
     Result := True;
  except
     ShowMessage('   BitMap');
  end;
end; // of function

// =========================================================================
//                                
// =========================================================================
end.
